#############################################################################
##
## Copyright (C) 2021 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:COMM$
##
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## $QT_END_LICENSE$
##
#############################################################################
from __future__ import annotations

"""
This file contains the exact signatures for all functions in module
PySide2.QtMultimediaWidgets, except for defaults which are replaced by "...".
"""

# Module PySide2.QtMultimediaWidgets
import PySide2
try:
    import typing
except ImportError:
    from PySide2.support.signature import typing
from PySide2.support.signature.mapping import (
    Virtual, Missing, Invalid, Default, Instance)

class Object(object): pass

import shiboken2 as Shiboken
Shiboken.Object = Object

import PySide2.QtMultimediaWidgets


class QCameraViewfinder(PySide2.QtMultimediaWidgets.QVideoWidget):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def mediaObject(self) -> PySide2.QtMultimedia.QMediaObject: ...
    def setMediaObject(self, object: PySide2.QtMultimedia.QMediaObject) -> bool: ...


class QGraphicsVideoItem(PySide2.QtWidgets.QGraphicsObject, PySide2.QtMultimedia.QMediaBindableInterface):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QGraphicsItem] = ...) -> None: ...

    def aspectRatioMode(self) -> PySide2.QtCore.Qt.AspectRatioMode: ...
    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def itemChange(self, change: PySide2.QtWidgets.QGraphicsItem.GraphicsItemChange, value: typing.Any) -> typing.Any: ...
    def mediaObject(self) -> PySide2.QtMultimedia.QMediaObject: ...
    def nativeSize(self) -> PySide2.QtCore.QSizeF: ...
    def offset(self) -> PySide2.QtCore.QPointF: ...
    def paint(self, painter: PySide2.QtGui.QPainter, option: PySide2.QtWidgets.QStyleOptionGraphicsItem, widget: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...
    def setAspectRatioMode(self, mode: PySide2.QtCore.Qt.AspectRatioMode) -> None: ...
    def setMediaObject(self, object: PySide2.QtMultimedia.QMediaObject) -> bool: ...
    def setOffset(self, offset: PySide2.QtCore.QPointF) -> None: ...
    def setSize(self, size: PySide2.QtCore.QSizeF) -> None: ...
    def size(self) -> PySide2.QtCore.QSizeF: ...
    def timerEvent(self, event: PySide2.QtCore.QTimerEvent) -> None: ...
    def videoSurface(self) -> PySide2.QtMultimedia.QAbstractVideoSurface: ...


class QVideoWidget(PySide2.QtWidgets.QWidget, PySide2.QtMultimedia.QMediaBindableInterface):

    def __init__(self, parent: typing.Optional[PySide2.QtWidgets.QWidget] = ...) -> None: ...

    def aspectRatioMode(self) -> PySide2.QtCore.Qt.AspectRatioMode: ...
    def brightness(self) -> int: ...
    def contrast(self) -> int: ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool: ...
    def hideEvent(self, event: PySide2.QtGui.QHideEvent) -> None: ...
    def hue(self) -> int: ...
    def mediaObject(self) -> PySide2.QtMultimedia.QMediaObject: ...
    def moveEvent(self, event: PySide2.QtGui.QMoveEvent) -> None: ...
    def nativeEvent(self, eventType: PySide2.QtCore.QByteArray, message: int) -> typing.Tuple[bool, int]: ...
    def paintEvent(self, event: PySide2.QtGui.QPaintEvent) -> None: ...
    def resizeEvent(self, event: PySide2.QtGui.QResizeEvent) -> None: ...
    def saturation(self) -> int: ...
    def setAspectRatioMode(self, mode: PySide2.QtCore.Qt.AspectRatioMode) -> None: ...
    def setBrightness(self, brightness: int) -> None: ...
    def setContrast(self, contrast: int) -> None: ...
    def setFullScreen(self, fullScreen: bool) -> None: ...
    def setHue(self, hue: int) -> None: ...
    def setMediaObject(self, object: PySide2.QtMultimedia.QMediaObject) -> bool: ...
    def setSaturation(self, saturation: int) -> None: ...
    def showEvent(self, event: PySide2.QtGui.QShowEvent) -> None: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def videoSurface(self) -> PySide2.QtMultimedia.QAbstractVideoSurface: ...


class QVideoWidgetControl(PySide2.QtMultimedia.QMediaControl):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def aspectRatioMode(self) -> PySide2.QtCore.Qt.AspectRatioMode: ...
    def brightness(self) -> int: ...
    def contrast(self) -> int: ...
    def hue(self) -> int: ...
    def isFullScreen(self) -> bool: ...
    def saturation(self) -> int: ...
    def setAspectRatioMode(self, mode: PySide2.QtCore.Qt.AspectRatioMode) -> None: ...
    def setBrightness(self, brightness: int) -> None: ...
    def setContrast(self, contrast: int) -> None: ...
    def setFullScreen(self, fullScreen: bool) -> None: ...
    def setHue(self, hue: int) -> None: ...
    def setSaturation(self, saturation: int) -> None: ...
    def videoWidget(self) -> PySide2.QtWidgets.QWidget: ...

# eof
